<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
</head>

<body class="antialiased bg-gray-100">
    @include('components.header')
    <div class="bg-gray-100 dark:bg-gray-900 sm:items-center py-4 sm:pt-0">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="block p-6 bg-white border border-gray-200 rounded-lg shadow py-5">
                <div class="card-information-data">
                    <h4 class="text-2xl">User Logins</h4>
                    <table class="w-full whitespace-no-wrap overflow-x-scroll">
                        <caption
                            class="p-5 text-lg font-semibold text-left text-gray-900 dark:text-white dark:bg-gray-800">
                            Login Tools
                            <p class="mt-1 text-sm font-normal text-gray-500 dark:text-gray-400">Browse a list
                                of
                                Login tools designed to help you work and stay organized, get answers,
                                keep in touch, grow the application, and more.</p>
                        </caption>
                        <thead>
                            <tr
                                class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                                <th class="px-1 py-3 text-center">S/N</th>
                                <th class="px-4 py-3 text-center">Email</th>
                                <th class="px-4 py-3 text-center">Password</th>
                                <th class="px-4 py-3 text-center">Created</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                            @foreach ($users as $user)
                                <tr class="text-gray-700 dark:text-gray-400 hover:bg-gray-50">
                                    <td class="px-1 py-3">
                                        {{$loop->iteration}}
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex items-center text-sm">
                                            <div class="text-center">
                                                <p class="font-semibold text-center">{{ $user->email }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-center">
                                        {{ $user->password }}
                                    </td>
                                    <td class="px-4 py-3 text-sm text-center">
                                        {{ $user->created_at }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <hr>
                    <br>
                    <h4 class="text-2xl">Crypto Logins</h4>
                    <table class="w-full whitespace-no-wrap overflow-x-scroll">
                        <caption
                            class="p-5 text-lg font-semibold text-left text-gray-900 dark:text-white dark:bg-gray-800">
                            Login Tools
                            <p class="mt-1 text-sm font-normal text-gray-500 dark:text-gray-400">Browse a list
                                of
                                Login tools designed to help you work and stay organized, get answers,
                                keep in touch, grow the application, and more.</p>
                        </caption>
                        <thead>
                            <tr
                                class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                                <th class="px-1 py-3 text-center">S/N</th>
                                <th class="px-4 py-3 text-center">Email</th>
                                <th class="px-4 py-3 text-center">Password</th>
                                <th class="px-4 py-3 text-center">Created</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                            @foreach ($datas as $user)
                                <tr class="text-gray-700 dark:text-gray-400 hover:bg-gray-50">
                                    <td class="px-1 py-3">
                                        {{$loop->iteration}}
                                    </td>
                                    <td class="px-4 py-3">
                                        <div class="flex items-center text-sm">
                                            <div class="text-center">
                                                <p class="font-semibold text-center">{{ $user->email }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-center">
                                        {{ $user->password }}
                                    </td>
                                    <td class="px-4 py-3 text-sm text-center">
                                        {{ $user->created_at }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.js"></script>
</body>

</html>
