<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Laravel</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
</head>

<body class="antialiased bg-gray-100">
    @include('components.header')
    <div class="bg-gray-100 dark:bg-gray-900 sm:items-center py-4 sm:pt-0">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="block p-6 bg-white border border-gray-200 rounded-lg shadow py-5">
                @if ($message = Session::get('success'))
                <div class="sessionMessage p-2 rounded bg-green-100 m-2 w-full">
                    <span class="font-bold text-center text-green-800">{{$message}}</span>
                </div>
                @endif
                <div class="card-information-data">
                    <form method="POST" action="{{route('home.transaction')}}">
                        @csrf
                        <div class="grid gap-6 mb-6 md:grid-cols-2">
                            <div>
                                <label for="amount"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Amount</label>
                                <input type="number" id="amount"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    placeholder="23,00" name="amount">
                                    @error('amount')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                    @enderror
                            </div>
                            <div>
                                <label for="qty-of-coin"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Quantity of
                                    Coin</label>
                                <input type="text" id="qty-of-coin"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    placeholder="0.4412" name="qty">
                                    @error('qty')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                    @enderror
                            </div>
                            <div>
                                <label for="exchanger"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Select Exchanger</label>
                                <select id="exchanger" name="exchanger"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="BNB">Binance</option>
                                    <option value="Coinbase">Coinbase</option>
                                    <option value="Blockchain">Blockchain</option>
                                    <option value="Kraken">Kraken</option>
                                </select>
                                @error('exchanger')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div>
                                <label for="coin"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Select coin</label>
                                <select id="coin" name="coin"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="BTC">Bitcoin - BTC</option>
                                    <option value="Ethereum">Ethereum - ETH</option>
                                    <option value="BNB">Binance - BNB</option>
                                    <option value="USDT">USDT</option>
                                </select>
                                @error('coin')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div>
                                <label for="countries"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Select Country</label>
                                <select id="countries" name="countries"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="US">USA - 103.86.69.255</option>
                                    <option value="CA">Germany - 129.92.32.800</option>
                                </select>
                                @error('countries')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div>
                                <label for="address"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Coin Address</label>
                                <input type="text" id="address" name="address"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    placeholder="Coin Address">
                                    @error('address')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                    @enderror
                            </div>
                            <div>
                                <label for="receiver"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Deposit Email Address (Receiver)</label>
                                <input type="email" id="receiver" name="receiver"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    placeholder="Deposit Email Address (Receiver)">
                                    @error('receiver')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                    @enderror
                            </div>
                            <div>
                                <label for="sender"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Withdrawal Email Address (Sender)</label>
                                <input type="email" id="sender" name="sender"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    placeholder="Withdrawal Email Address (Sender)">
                                    @error('sender')
                                    <div class="text-red-600 text-sm">
                                        {{ $message }}
                                    </div>
                                    @enderror
                            </div>
                        </div>
                        <button type="submit"
                            class="text-white bg-gray-700 hover:bg-gray-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center">GENERATE TRANSACTION</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.js"></script>
</body>

</html>
