/** @type {import('tailwindcss').Config} */
const colors = require('tailwindcss/colors')
module.exports = {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
  ],
  darkMode: 'class',
  theme: {
    screens: {
        sm: '480px',
        ds: '468px',
        mds: '587px',
        mdd: '687px',
        md: '768px',
        lg: '976px',
        ls: '1076px',
        mls: '1176px',
        mll: '1276px',
        mlg: '1376px',
        xl: '1440px',
        bxl: '2008px',
        blg: '2890px'
      },
      colors: {
        gray: colors.gray,
        blue: colors.skyBlue,
        red: colors.rose,
        pink: colors.fuchsia,
      },
      fontFamily: {
        sans: ['Graphik', 'sans-serif'],
        serif: ['Merriweather', 'serif'],
      },
      extend: {
        spacing: {
          '128': '32rem',
          '144': '36rem',
        },
        borderRadius: {
          '4xl': '2rem',
        }
      }
  },
  plugins: [
    require('flowbite/plugin')
  ],
}

